import junit.framework.TestCase;

/*
 * Created on Sep 23, 2003
 *
  * @author TJR
 *
 *  */
public class MovieListTest extends TestCase {

	private MovieList movieList = null;
	private Movie starWars =  null;
	private Movie starTrek = null;
	private Movie starGate = null;
	/**
	 * Constructor for MovieListTest.
	 * @param arg0
	 */
	public MovieListTest(String arg0) {
		super(arg0);
	}
	
	public void setUp(){				// setUp() is run before each test case execution
		movieList = new MovieList();
		starWars = new Movie();
		starTrek = new Movie();
		starGate = new Movie();
	}
	
	public void testEmptyListSize(){
		assertEquals("Size of empty movie list should be 0.",0,movieList.size());
	}
	
	public void testSizeAfterAddingOne(){
		movieList.add(starWars);
		assertEquals("Size of one item list should be 1.",1,movieList.size());
	}
	
	public void testSizeAfterAddingTwo() {
		movieList.add(starWars);
		movieList.add(starTrek);
		assertEquals("Size of two item list should be 2.",2,movieList.size());
	}
	
	public void testContents(){
		movieList.add(starWars);
		movieList.add(starTrek);
		assertTrue("List should contain starWars.",movieList.contains(starWars));
		assertTrue("List should contain starTrek.",movieList.contains(starTrek));
		assertFalse("List should not contain starGate.",movieList.contains(starGate));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(MovieListTest.class);
	}

}
