#include <string>
#include <iostream>
#include <limits>

#include "rules.h"

using namespace std;

// The main function. Manages the game
int main (int arg_count, char* args[]) {
    
    string input;

    cout << "==== The C++ TDD Password Game ====" << endl;

    while (true) {

        cout << endl << "Enter a password: ";
        getline(cin, input);
        vector<string> errors = evaluateAllRules(input);

        if (errors.empty()) {
            cout << "Password accepted! All rules are satisfied!" << endl;
            break;
        }

        for (auto& message: errors) {
            cout << "❌ " << message << endl;
        } 

    }

    return 0;

}