#include <string>
#include <iostream>
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory>

#include "practice_final.h"

using namespace std;

// Test Counter
static int test_number = 1;

// Resest the test counter
void reset_test_counter() {
    test_number = 1;
}

// Assert function. DO NOT MODIFY THIS CODE
// Call with the result of a test, and the message to print to the console. An Example is commented out for you below
int assert(bool test_result, const string& error_message) {
    int result = 1;
    if (!test_result) {
        
        ostringstream oss;
        oss << "Test # " << test_number << " failed: " << error_message;
        cout << oss.str() << endl;
        result = 0;
    }
    test_number++;
    return result;
}

// All unit tests
int unitTests() {

    int passcount = 0;
    int failcount = 0;

    // Test Fix Broken
    cout << "=== Testing fix_broken===" << endl;
    reset_test_counter();
    
    char s1[] = "hello";
    char s2[] = "world";
    char empty[] = "";
    // Test 1
    int broken_result = fix_broken(NULL, s1);
    assert(broken_result == 0, 
            "Invalid parameter provided, expected 0, got " + to_string(broken_result))
            ? passcount++ : failcount++;
    
    // Test 2
    broken_result = fix_broken(s1, NULL);
    assert(broken_result == 0, 
            "Invalid parameter provided, expected 0, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 3
    broken_result = fix_broken(NULL, NULL);
    assert(broken_result == 0, 
            "Invalid parameter provided, expected 0, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 4
    broken_result = fix_broken(empty, s1);
    assert(broken_result == 0, 
            "Invalid parameter provided, expected 0, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 5
    broken_result = fix_broken(empty, empty);
    assert(broken_result == 0, 
            "Invalid parameter provided, expected 0, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 6
    broken_result = fix_broken(s1, s1);
    assert(broken_result == 1, 
            "p2 points to first chracter of p1, expected 1, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 7
    broken_result = fix_broken(s1, s1+1);
    assert(broken_result == 1, 
            "p2 points to second chracter of p1, expected 1, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 8
    broken_result = fix_broken(s1, s1+4);
    assert(broken_result == 1, 
            "p2 points to last chracter of p1, expected 1, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 9
    broken_result = fix_broken(s1, s1+5);
    assert(broken_result == -1, 
            "p2 points to null terminator of p1, expected -1, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 10
    broken_result = fix_broken(s1, s2);
    assert(broken_result == -1, 
            "p2 points to a different string than p1, expected -1, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test 11
    broken_result = fix_broken(s1, s2+2);
    assert(broken_result == -1, 
            "p2 points to a different string than p1, expected -1, got " + to_string(broken_result))
            ? passcount++ : failcount++;

    // Test Regex
    cout << "===Testing regex_vowels===" << endl;
    reset_test_counter();
    // Test 1
    int res = regex_vowels("CHEESE");
    assert(res == 0, "Tested string \"CHEESE\", Expected 0 Matches, Got " + to_string(res) ) 
        ? passcount++ : failcount ++;

    // Test 2
    res = regex_vowels("ROCHESTER INSTITUTE OF TECHNOLOGY");
    assert(res == 3, "Tested string \"ROCHESTER INSTITUTE OF TECHNOLOGY\", Expected 3 Matches, Got " + to_string(res) ) 
        ? passcount++ : failcount ++;

    // Test 3
    res = regex_vowels("RIT TIGERS ROAR LOUD IN ARENA");
    assert(res == 4, "Tested string \"RIT TIGERS ROAR LOUD IN ARENA\", Expected 4 Matches, Got " + to_string(res) ) 
        ? passcount++ : failcount ++;

    // Test 4
    res = regex_vowels("ITS THE LAST WEEK BEFORE EXAMS");
    assert(res == 2, "Tested string \"ITS THE LAST WEEK BEFORE EXAMS\", Expected 2 Matches, Got " + to_string(res) ) 
        ? passcount++ : failcount ++;
    
    // Test 5
    res = regex_vowels("MY STUDENTS WILL ALL DO GREAT");
    assert(res == 1, "Tested string \"MY STUDENTS WILL ALL DO GREAT\", Expected 1 Match, Got " + to_string(res) ) 
        ? passcount++ : failcount ++;

    // Test Combine Strings
    cout << "===Testing combine_strings===" << endl;
    reset_test_counter();
	// Test 1
    char t1[] = "a";
    assert( combine_strings( NULL, t1 )  == NULL,
		"Expected NULL because str1 is NULL" )
		? passcount++ : failcount++ ;
    
    // Test 2
    char t2[] = "b";
	assert( combine_strings( t2, NULL ) == NULL,
		"Expected NULL because str2 is NULL" )
		? passcount++ : failcount++ ;

    // Test 3
    char t3a[] = "one ";
    char t3b[] = "two";
    char *ptest3 = combine_strings( t3a, t3b ) ;
	int good_pointer = ( ptest3 != NULL && ptest3 != BOGUS_POINTER ) ;
	assert( good_pointer,
		"Expected valid pointer but but it is NULL or BOGUS_POINTER" )
		? passcount++ : failcount++ ;

    // Test 4
	if ( ! good_pointer )
	{
		assert( 0,
			 "Skipping test 4 due to bad pointer from test 3" ) ;
		failcount++ ;
	}
	else {
        assert( strcmp( ptest3, "one two" ) == 0,
			string("Expected \"one two\" but got \"") + ptest3 + string("\"") )
		? passcount++ : failcount++ ;
        free(ptest3);
    }
	
    //Test shift_multiply
    cout << "===Testing shift_multiply===" << endl;
    reset_test_counter();

    // Test 1
    res = shift_multiply(16);
    assert(res == 40, 
            "Multiplied 16 by 2.5. Expected 40, got " + to_string(res))
            ? passcount++ : failcount++ ;

    // Test 2
    res = shift_multiply(6);
    assert(res == 15, 
            "Multiplied 6 by 2.5. Expected 15, got " + to_string(res))
            ? passcount++ : failcount++ ;
    
    // Test 3
    res = shift_multiply(256);
    assert(res == 640, 
            "Multiplied 256 by 2.5. Expected 640, got " + to_string(res))
            ? passcount++ : failcount++ ;


    // Test class work
    cout << "===Testing Rectangle Class===" << endl;
    reset_test_counter();

    unique_ptr<Rectangle> rect1 = make_unique<Rectangle>(3.0, 4.0);
    double r1area = rect1 -> area();
    double r1per = rect1 -> perimeter();

    // Test 1
    assert(r1area == 12.0,
        "Calculated area for a rectangle with sides 3.0 and 4.0, expected area of 12. Got " + to_string(r1area))
        ? passcount++ : failcount++;

    // Test 2
    assert(r1per == 14,
        "Calculated perimeter for a rectangle with sides 3.0 and 4.0, expected perimeter of 12. Got " + to_string(r1per))
        ? passcount++ : failcount++;

    unique_ptr<Rectangle> rect2 = make_unique<Rectangle>(25.0, 25.0);
    double r2area = rect2 -> area();
    double r2per = rect2 -> perimeter();
    
    // Test 3
    assert(r2area == 625.0,
        "Calculated area for a rectangle with sides 25.0 and 25.0, expected area of 625.0. Got " + to_string(r2area))
        ? passcount++ : failcount++;

    // Test 4
    assert(r2per == 100,
        "Calculated perimeter for a rectangle with sides 25.0 and 25.0, expected perimeter of 100.0 Got " + to_string(r2per))
        ? passcount++ : failcount++;

    // Test sum_odds
    cout << "===Testing sum_odds===" << endl;
    reset_test_counter();
    
    int result = 0 ;
    // Test 1
	result = sum_odds( NULL, 5 ) ;
	assert( result == BAD_PARAMETERS,
		"Expect BAD_PARAMETERS because p_integers is NULL but got " + to_string(result))
		? passcount++ : failcount++ ;

	// Test 2 
	int array1[] = { 0, 1 } ;
	result = sum_odds( array1, 0 ) ;
	assert( result == BAD_PARAMETERS,
		"Expect BAD_PARAMETERS because number of integers is 0 but got " + to_string(result))
		? passcount++ : failcount++ ;

	// Test 3
	result = sum_odds( array1, -1 ) ;
	assert( result == BAD_PARAMETERS,
		"Expect BAD_PARAMETERS because number of integers is -1 but got " + to_string(result))
		? passcount++ : failcount++ ;

	// Test 4
	result = sum_odds( array1, 2 ) ;
	assert( result == 1,
		"Expect 1 because there is one odd integer with the value 1 but got " + to_string(result))
		? passcount++ : failcount++ ;

	// Test 5
	int array2[] = { 3, 8, 6, -1, 44, 99 } ;
	result = sum_odds( array2, 6 ) ;
	assert( result == 101,
		"Expect 101 because 3 - 1 + 99 is 101 but got " + to_string(result))
		? passcount++ : failcount++ ;

    // Print counts
    cout << "Tests Passed: " << passcount << endl;
    cout << "Tests Failed: " << failcount << endl;

    return passcount;
}

int main(int arg_count, char* args[]) {
    return unitTests();
}
