#include "Rectangle.h"
#include <iostream>

Rectangle::Rectangle(const std::string& id, double w, double h) : Shape(id), width(w), height(h) {
        std::cout << "Created rectangle with width " << w << " and height " << h <<  std::endl;
}

double Rectangle::area() const {
    return width * height;
}

double Rectangle::perimeter() const {
    return 2 * (width + height);
}

Rectangle::~Rectangle() {
    std::cout << "Destroying Rectangle with ID: " << id << std::endl;
}
