#include <iostream>
#include <vector>
#include <random>
#include "Circle.h"
#include "Rectangle.h"
#include "Triangle.h"

Shape* generateRandomShape(std::mt19937 &gen, int index) {
    std::uniform_int_distribution<> shapeDist(0, 2);
    std::uniform_real_distribution<> sizeDist(1.0, 10.0);

    int choice = shapeDist(gen);
    if (choice == 0) {
        double r = sizeDist(gen);
        std::cout << "Generated Circle radius=" << r << std::endl;;
        return new Circle("Circle_" + std::to_string(index), r);
    } else if (choice == 1) {
        double w = sizeDist(gen);
        double h = sizeDist(gen);
        std::cout << "Generated Rectangle width=" << w << " height=" << h << std::endl;
        return new Rectangle("Rectangle_" + std::to_string(index), w, h);
    } else {
        double a, b, c;
        do {
            a = sizeDist(gen);
            b = sizeDist(gen);
            c = sizeDist(gen);
        } while (a + b <= c || a + c <= b || b + c <= a);
        std::cout << "Generated Triangle sides=" << a << "," << b << "," << c << std::endl;
        return new Triangle("Triangle_" + std::to_string(index), a, b, c);
    }
}

int main() {
    std::random_device rd;
    std::mt19937 gen(rd());

    std::vector<Shape*> shapes;

    for (int i = 0; i < 10; ++i) {
        shapes.push_back(generateRandomShape(gen, i));
    }

    std::cout << std::endl << std::endl << std::endl;
    double totalArea = 0;
    double totalPerimeter = 0;

    for (Shape* s : shapes) {
        totalArea += s->area();
        totalPerimeter += s->perimeter();
    }

    std::cout << "Total Area: " << totalArea << std::endl;
    std::cout << "Total Perimeter: " << totalPerimeter << std::endl;

    std::cout << std::endl << std::endl << std::endl;


    for (Shape* s : shapes) {
        delete s; 
    }

    return 0;
}
