#include "Triangle.h"
#include <cmath>
#include <iostream>

Triangle::Triangle(const std::string& id, double side1, double side2, double side3)
    : Shape(id), a(side1), b(side2), c(side3) {
        std::cout << "Created triangle with side a " << side1 << ", side b " << side2 << ", and side c " << side3 << std::endl;
}

double Triangle::area() const {
    double s = (a + b + c) / 2.0;
    return std::sqrt(s * (s - a) * (s - b) * (s - c));
}

double Triangle::perimeter() const {
    return a + b + c;
}

Triangle::~Triangle() {
    std::cout << "Destroying Triangle with ID: " << id << std::endl;
}
