import React from 'react';
import {Container} from 'reactstrap';


import Keys from './Keys';

 
class Page extends React.Component
{

    constructor(props)
    {
        super(props);
        this.state = {list: []};
    }



    buttonSelect=(key)=>
    {
        alert('Selection:' + key);

    }

    updateData=(data)=>
    {
        this.setState({list: data});
    }



    //This method makes the API call to retrieve the data from the server using RESTful API
    fetchData = () => {
        //With Flask CORS enabled, we can directly call the server on port 5000
        fetch('http://localhost:5000/vend')
         .then( 
             (response) => 
             {
                return response.json() ;
             }
             )//The promise response is returned, then we extract the json data
         .then (jsonOutput => //jsonOutput now has result of the data extraction
                  {
                     this.updateData(jsonOutput)
                    }
              )
         .catch((error => console.log("**Fetch exception:" + error)))
      }

    //When the component is loaded, this will call the fetchData method to retrieve the data
    componentDidMount(){
        this.fetchData();
    } 
    render()
    {
        console.log(this.state.list);
        if (this.state.list.length > 0)
        {
        return(
        <div>
        <h3 className='flex-container centered'>Mini Vend</h3>
        <Container className='mt-1 flex-container centered' >
            {this.state.list}
        </Container>
        <Keys callback={this.buttonSelect}></Keys>
        </div>
        )
        }
        else
        return(
        <div>
            <Container className='centered'>
            <h2>No data available</h2>
            <img src='./img/ded.png' alt='dead emoji'></img>
            <h3>Make sure the server is up and running</h3>
            </Container>
            <Keys callback={this.buttonSelect}></Keys>
        </div>
            )
    }
}

export default Page;