package example.controller;

import example.beans.User;
import example.model.UserDAO;

public class ManageUsers {

	private final UserDAO userDAO;

	public ManageUsers(UserDAO userDAO) {
		this.userDAO = userDAO;
	}

	public User getUser(String userString) {
		validate(userString);
		User user = userDAO.find(userString);
		return user;
	}
	
	private void validate(String userString) {
		if (!userString.matches("[a-zA-Z]*"))
			throw new IllegalArgumentException("Only letters & numbers");
	}

}
