package example.controller.manageusers;

import static org.easymock.EasyMock.expect;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Before;
import org.junit.Test;

import example.beans.User;
import example.controller.ManageUsers;
import example.model.UserDAO;

public class GetUserTest {
	private final IMocksControl ctrl = EasyMock.createControl();
	private final UserDAO mockUserDAO = ctrl.createMock(UserDAO.class);
	private final User mockUser = ctrl.createMock(User.class);

	@Before
	public void init() {
		ctrl.reset();
	}

	@Test
	public void lookupBobby() throws Exception {
		// Establish expectations
		expect(mockUserDAO.find("BobbyTables")).andReturn(mockUser).once();
		ctrl.replay();

		// Run & Verify
		ManageUsers manage = new ManageUsers(mockUserDAO);
		assertEquals(mockUser, manage.getUser("BobbyTables"));
		ctrl.verify();
	}

	@Test
	public void lookupInvalidInput() throws Exception {
		// Establish expectations
		// note the absence of a mock call!
		ctrl.replay();

		// Run & Verify
		ManageUsers manage = new ManageUsers(mockUserDAO);
		try {
			manage.getUser("' OR TRUE; --");
			fail("exception should have been thrown!");
		} catch (IllegalArgumentException e) {
			assertEquals("Only letters & numbers", e.getMessage());
		}
		ctrl.verify();
	}
}
